<!DOCTYPE html>
<html>
<head>
    <title>Titolo della pagina</title>
<style>
    table, th, td {
        border: 1px solid black;
    }
    header{
        text-align: center;
    }

    li {
        list-style-type: none;
    }  

    #menu{
        margin-top: 0px; 
        width: 20%;
        background-color:gray;
        float: right;
    }

    #content{
        margin-top: 0px; 
        width: 75%;
        background-color:yellow;
        float: left;
    }

</style>
</head>

<body>

<?php

        /* 
        Prima di qualsiasi altra cosa, facciamo in modo che, una volta aperta la pagina php, il sistema si connetta al DATABASE. 
        Notiamo, inoltre, che non è necessario che il codice PHP sia tutto nell stesso punto. E' sufficiente aprire e chiudere il tag per inserirlo dove ci serve. 
        In questo caso abbiamo, infatti: 
        <?php 
            CODICE DI CONNESSIONE AL DATABASE
        ?> 
        Poi abbiamo altri tag e codice HTML (ci saranno l'HEADER della pagina e la TABELLA), dopo di chè (all'interno della tabella) 
        possiamo riaprire il tag php e inserire il codice per la query. 
        */

        // Create connection
        // Il metodo accetta in ingresso: mysqli_connect("127.0.0.1", "my_user", "my_password", "my_db");
        $db = mysqli_connect('127.0.0.1:3306','test','','test');
        
        // Check connection
        if ($db->connect_error) {
            die("Connection failed: " . $db->connect_error);
        } 
        /* //Questo else è commentato perchè per la consegna non è necessario che stampiate che la connessione è riuscita. Viene verificato con le query. 
        else{
            echo "Connected successfully, OK";
        }
        */

?>

    <!-- INIZIO SEZIONE HEADER. DA PERSONALIZZARE CON UN'IMMAGINE O CON LA DESCRIZIONE DEL VOSTRO SITO -->
    <!-- NOTATE CHE PER INSERIRE UN COMMENTO ALL'INTERNO DEL CODICE HTML USIAMO UN TAG SPECIFICO DI HTML, CIOè QUELLO CHE 'CIRCONDA' QUESTO MESSAGGIO -->
    <header>
        <hgroup>
            <h1>Aggiungiamo un Header</h1>
            <h3>Che Spiega la funzione del sito</h2>
            <img src="img/module_table_bottom.png">
        </hgroup>
        <hr>
    </header>
    <!-- FINE SEZIONE HEADER. DA PERSONALIZZARE CON UN'IMMAGINE O CON LA DESCRIZIONE DEL VOSTRO SITO -->


    <!-- INIZIO SEZIONE CONTENT (ATTUALMENTE BACKGROUND GIALLO). RAPPRESENTA IL CUORE DELLA PAGINA, DOVE VENGONO DINAMICAMENTE POPOLATE LE TABELLE CON I RISULTATI DELLE QUERY -->
    <div id="content">
    
    <!-- INIZIO TABELLA --> 
    <table>
        <tr>
            <th>Firstname</th>
            <th>Lastname</th> 
            <th>Age</th>
        </tr>
        

        <?php
        // INIZIO SEZIONE DI PHP PER STAMPARE LE RIGHE DELLA TABELLA SULLA BASE DI QUELLO CHE RESTITUISCE LA QUERY

        // QUERY: Recuperiamo le colonne "nomeColonna1", "nomeColonna2" e "nomeColonna3" dalla Tabella "nomeTabella" ordinando in modo ascendete (dal più piccolo al più grande)
        
        //popolo una variabile "res" con quello che viene restituito dal DB
        $res = $db->query("SELECT nomeColonna1, nomeColonna2, nomeColonna3 FROM nomeTabella ORDER BY id ASC");        

        // Per ognuna delle tuple recuperate dal database, vado a stampare il risultato        
        for ($row_no = 0; $row_no <= $res->num_rows - 1; $row_no++) {
            $res->data_seek($row_no);                                   // con data_seek indico quale riga del risultato devo andare ad analizzare, sarebbe come elemento[i-esimo] in java. 
            $row = $res->fetch_assoc();                                 // Tratta la singola riga (quindi un elemento del vettore) come un array associativo
            // stampo (con echo) il tag html per la nuova riga della tabella, il tag per la nuova colonna della tabella, i valori che devono assumere, e poi i tag di chiusura per quelli aperti in precedenza.
            echo " <tr><td>id = " . $row['nomeColonna1'] . "</td><td>" . $row['nomeColonna2'] . "</td><td>" . $row['nomeColonna3'] . "</td></tr>";
        }
        //chiudo il tag PHP
        ?>
    </table>
    <!-- Fine TABELLA -->

    <br/><br/> <!-- il comando per andare a capo -->
    
    </div>
    <!-- Fine SEZIONE CONTENT (ATTUALMENTE BACKGROUND GIALLO). -->



    <!-- INIZIO SEZIONE Menu (ATTUALMENTE BACKGROUND Grigio). RAPPRESENTA IL MENù TRAMITE CUI ACCEDERE ALLE DIVERSE PAGINE, DEVE ESSERE UGUALE IN TUTTE -->
    <div id="menu">
        <ul> <!-- LISTA NON ORDINATA, PER EVITARE LA NUMERAZIONE-->
            <li><button >Test</button></li> <!-- LIST ITEM -->
            <a href="index_6_tableQuery.php"><li><button>Test</button></li></a> 
            <!-- 
                LIST ITEM CON ANNESSO LINK. NOTIAMO CHE ESSENDO QUESTO FILE IN CUI INSERISCO IL TAG  NELLA STESSA DIRECTORY DI QUELLO DI DESTINAZIONE, NON C'E' BISOGNO DI AGGIUNGERE NIENT'ALTRO SE NON IL NOME DEL FILE. 
                FATE IN MODO CHE I FILE SIANO SEMPRE SULLO STESSO LIVELLO. ALTRIMENTI RISCHIATE DI AVERE GROSSI PROBLEMI.  
            -->
            <li><button>Test</button></li> <!-- LIST ITEM -->
        <ul>
    </div>
    <!-- FINE SEZIONE Menu (ATTUALMENTE BACKGROUND Grigio) -->


    

</body>
</html>